<?php

namespace Ptb\Grafx\Requests;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Creates My Project
 *
 * Creates My Project. Name is optional; when not set, the Template name is used
 */
class StoreProjectRequest extends Request implements HasBody
{
    use HasJsonBody;

    protected Method $method = Method::POST;

    public function resolveEndpoint(): string
    {
        return "/api/v1/environment/$this->environment/projects";
    }

    protected function defaultBody(): array
    {
        return $this->data;
    }

    public function __construct(
        protected string $environment,
        protected array  $data,
    )
    {
    }
}
