<?php

namespace Ptb\Grafx\Requests;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Represents a request to read a specific template collection from a given environment.
 *
 * Extends the base Request class and defines the GET HTTP method for retrieving
 * resource data from the specified endpoint.
 */
class ReadTemplateCollectionRequest extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/$this->environment/template-collections/$this->templateCollectionId";
	}

	/**
	 * @param string $environment Name of the environment
	 * @param string $templateCollectionId ID of the template collection
	 */
	public function __construct(
		protected string $environment,
		protected string $templateCollectionId,
	) {
	}
}
