<?php

namespace Ptb\Grafx\Requests;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Represents a request to retrieve a specific task from the API.
 *
 * This request targets a specific environment and task ID, using the GET HTTP method.
 * The endpoint for this request is dynamically resolved based on the provided environment and task ID.
 *
 * @extends Request
 */
class ReadTaskRequest extends Request
{
    protected Method $method = Method::GET;


    public function resolveEndpoint(): string
    {
        return "/api/v1/environment/$this->environment/output/tasks/$this->taskId";
    }

    public function __construct(
        protected string $environment,
        protected string $taskId,
    )
    {
    }
}
