<?php

namespace Ptb\Grafx\Requests;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Represents a request to get the output of a specific task in a given environment.
 *
 * Extends the base Request class to handle the endpoint resolution for downloading task outputs.
 *
 * The resolved endpoint will be generated dynamically using the provided environment name and task ID.
 *
 * The HTTP method used for this request is GET.
 *
 * @param string $environment Specifies the environment name where the task resides.
 * @param string $taskId Specifies the unique identifier of the task whose output is to be retrieved.
 */
class ReadTaskOutputRequest extends Request
{
    protected Method $method = Method::GET;

    public function resolveEndpoint(): string
    {
        return "/api/v1/environment/$this->environment/output/tasks/$this->taskId/download";
    }


    /**
     * @param string $environment Name of the environment
     * @param string $taskId ID of the task
     */
    public function __construct(
        protected string $environment,
        protected string $taskId,
    )
    {
    }
}
