<?php

namespace Ptb\Grafx\Requests;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Represents a request to retrieve all output settings for a specific environment.
 * Extends the base Request class and uses the GET HTTP method.
 * The class dynamically resolves the endpoint based on the provided environment.
 */
class ReadOutputSettingsRequest extends Request
{

    protected Method $method = Method::GET;

    public function resolveEndpoint(): string
    {
        return "/api/v1/environment/$this->environment/output/settings";
    }

    public function __construct(
        protected string $environment,
    )
    {
    }
}
