<?php

namespace Ptb\Grafx\Resource;

use Ptb\Grafx\Requests\TemplateCollections\CreatesNewTemplateCollectionInTheEnvironment;
use Ptb\Grafx\Requests\TemplateCollections\DeletesImageCoverOfTemplateCollection;
use Ptb\Grafx\Requests\TemplateCollections\DeletesTemplateCollectionByIdInTheEnvironment;
use Ptb\Grafx\Requests\TemplateCollections\DeletesTemplateFromTemplateCollection;
use Ptb\Grafx\Requests\TemplateCollections\RenamesTemplateInTemplateCollection;
use Ptb\Grafx\Requests\TemplateCollections\ReturnsAllTemplateCollectionsInTheEnvironment;
use Ptb\Grafx\Requests\TemplateCollections\ReturnsAllTemplatesAssignedToCollection;
use Ptb\Grafx\Requests\TemplateCollections\ReturnsImageCoverOfTemplateCollection;
use Ptb\Grafx\Requests\TemplateCollections\ReturnsTemplateCollectionByIdInTheEnvironment;
use Ptb\Grafx\Requests\TemplateCollections\SetsOrUpdatesImageCoverOfTemplateCollection;
use Ptb\Grafx\Requests\TemplateCollections\UpdatesTemplateCollectionByIdInTheEnvironment;
use Ptb\Grafx\Resource;
use Saloon\Http\Response;

class TemplateCollections extends Resource
{
	/**
	 * @param string $environment Name of the environment
	 * @param string $nextPageToken Next page token
	 * @param int $limit Amount of resources per response
	 */
	public function returnsAllTemplateCollectionsInTheEnvironment(
		string $environment,
		?string $nextPageToken,
		?int $limit,
	): Response
	{
		return $this->connector->send(new ReturnsAllTemplateCollectionsInTheEnvironment($environment, $nextPageToken, $limit));
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function createsNewTemplateCollectionInTheEnvironment(string $environment): Response
	{
		return $this->connector->send(new CreatesNewTemplateCollectionInTheEnvironment($environment));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateCollectionId ID of the template collection
	 */
	public function returnsTemplateCollectionByIdInTheEnvironment(
		string $environment,
		string $templateCollectionId,
	): Response
	{
		return $this->connector->send(new ReturnsTemplateCollectionByIdInTheEnvironment($environment, $templateCollectionId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateCollectionId ID of the template collection
	 */
	public function deletesTemplateCollectionByIdInTheEnvironment(
		string $environment,
		string $templateCollectionId,
	): Response
	{
		return $this->connector->send(new DeletesTemplateCollectionByIdInTheEnvironment($environment, $templateCollectionId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateCollectionId ID of the template collection
	 */
	public function updatesTemplateCollectionByIdInTheEnvironment(
		string $environment,
		string $templateCollectionId,
	): Response
	{
		return $this->connector->send(new UpdatesTemplateCollectionByIdInTheEnvironment($environment, $templateCollectionId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateCollectionId ID of the template collection
	 * @param string $nextPageToken Next page token
	 * @param int $limit Amount of resources per response
	 */
	public function returnsAllTemplatesAssignedToCollection(
		string $environment,
		string $templateCollectionId,
		?string $nextPageToken,
		?int $limit,
	): Response
	{
		return $this->connector->send(new ReturnsAllTemplatesAssignedToCollection($environment, $templateCollectionId, $nextPageToken, $limit));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateCollectionId ID of the template collection
	 * @param string $templateId ID of the template
	 */
	public function deletesTemplateFromTemplateCollection(
		string $environment,
		string $templateCollectionId,
		string $templateId,
	): Response
	{
		return $this->connector->send(new DeletesTemplateFromTemplateCollection($environment, $templateCollectionId, $templateId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateCollectionId ID of the template collection
	 * @param string $templateId ID of the template
	 */
	public function renamesTemplateInTemplateCollection(
		string $environment,
		string $templateCollectionId,
		string $templateId,
	): Response
	{
		return $this->connector->send(new RenamesTemplateInTemplateCollection($environment, $templateCollectionId, $templateId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateCollectionId ID of the template collection
	 */
	public function returnsImageCoverOfTemplateCollection(string $environment, string $templateCollectionId): Response
	{
		return $this->connector->send(new ReturnsImageCoverOfTemplateCollection($environment, $templateCollectionId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateCollectionId ID of the template collection
	 */
	public function setsOrUpdatesImageCoverOfTemplateCollection(
		string $environment,
		string $templateCollectionId,
	): Response
	{
		return $this->connector->send(new SetsOrUpdatesImageCoverOfTemplateCollection($environment, $templateCollectionId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateCollectionId ID of the template collection
	 */
	public function deletesImageCoverOfTemplateCollection(string $environment, string $templateCollectionId): Response
	{
		return $this->connector->send(new DeletesImageCoverOfTemplateCollection($environment, $templateCollectionId));
	}
}
