<?php

namespace Ptb\Grafx\Resource\Output;

use Ptb\Grafx\Requests\Output\CreatesGifOutputSettings;
use Ptb\Grafx\Requests\Output\CreatesJpgOutputSettings;
use Ptb\Grafx\Requests\Output\CreatesMp4OutputSettings;
use Ptb\Grafx\Requests\Output\CreatesPdfOutputSettings;
use Ptb\Grafx\Requests\Output\CreatesPngOutputSettings;
use Ptb\Grafx\Requests\Output\DeletesOutputSettingsByIdsInTheEnvironment;
use Ptb\Grafx\Requests\Output\ReturnsAllOutputSettingsInTheEnvironment;
use Ptb\Grafx\Requests\Output\ReturnsOutputSettingsByIdInTheEnvironment;
use Ptb\Grafx\Requests\Output\UpdatesOutputSettings;
use Ptb\Grafx\Resource;
use Saloon\Http\Response;

class Settings extends Resource
{
	/**
	 * @param string $environment Name of the environment
	 */
	public function returnsAllOutputSettingsInTheEnvironment(string $environment): Response
	{
		return $this->connector->send(new ReturnsAllOutputSettingsInTheEnvironment($environment));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $ids Comma-separated ids of Output Settings
	 */
	public function deletesOutputSettingsByIdsInTheEnvironment(string $environment, string $ids): Response
	{
		return $this->connector->send(new DeletesOutputSettingsByIdsInTheEnvironment($environment, $ids));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $outputSettingsId Output Settings ID
	 */
	public function returnsOutputSettingsByIdInTheEnvironment(string $environment, string $outputSettingsId): Response
	{
		return $this->connector->send(new ReturnsOutputSettingsByIdInTheEnvironment($environment, $outputSettingsId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $outputSettingsId Output Settings ID
	 */
	public function updatesOutputSettings(string $environment, string $outputSettingsId): Response
	{
		return $this->connector->send(new UpdatesOutputSettings($environment, $outputSettingsId));
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function createsJpgOutputSettings(string $environment): Response
	{
		return $this->connector->send(new CreatesJpgOutputSettings($environment));
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function createsPngOutputSettings(string $environment): Response
	{
		return $this->connector->send(new CreatesPngOutputSettings($environment));
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function createsPdfOutputSettings(string $environment): Response
	{
		return $this->connector->send(new CreatesPdfOutputSettings($environment));
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function createsGifOutputSettings(string $environment): Response
	{
		return $this->connector->send(new CreatesGifOutputSettings($environment));
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function createsMp4outputSettings(string $environment): Response
	{
		return $this->connector->send(new CreatesMp4OutputSettings($environment));
	}
}
