<?php

namespace Ptb\Grafx\Resource;

use Ptb\Grafx\Requests\Output\ReturnsTaskOutput;
use Ptb\Grafx\Requests\Output\ReturnsTaskStatus;
use Ptb\Grafx\Requests\Output\StartsAnimatedOutputTask;
use Ptb\Grafx\Requests\Output\StartsGifOutputTask;
use Ptb\Grafx\Requests\Output\StartsImageOutputTask;
use Ptb\Grafx\Requests\Output\StartsJpgOutputTask;
use Ptb\Grafx\Requests\Output\StartsMp4OutputTask;
use Ptb\Grafx\Requests\Output\StartsPdfOutputTask;
use Ptb\Grafx\Requests\Output\StartsPngOutputTask;
use Ptb\Grafx\Resource\Output\Settings;
use Ptb\Grafx\Resource;
use Saloon\Http\Response;

class Output extends Resource
{
    public function settings(): Settings
    {
        return new Settings($this->connector);
    }

	/**
	 * @param string $environment Name of the environment
	 * @param string $templateId ID of the Template
	 * @param string $projectId ID of My Project
	 * @param string $layoutToExport Index of template layout to export
	 * @param string $outputType Format of the output
	 * @param int $fps Framerate of the animated output (NOTE: for GIF output FPS should not exceed 50)
	 * @param float|int $pixelRatio Pixel ratio of the animated output
	 * @param string $engineVersion Override engine version to use during rendering
	 */
	public function startsAnimatedOutputTask(
		string $environment,
		?string $templateId,
		?string $projectId,
		?string $layoutToExport,
		?string $outputType,
		?int $fps,
		float|int|null $pixelRatio,
		?string $engineVersion,
	): Response
	{
		return $this->connector->send(new StartsAnimatedOutputTask($environment, $templateId, $projectId, $layoutToExport, $outputType, $fps, $pixelRatio, $engineVersion));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateId ID of the Template
	 * @param string $projectId ID of My Project
	 * @param string $outputType Format of the output
	 * @param string $layoutToExport Index of template layout to export
	 * @param float|int $pixelRatio Pixel ratio of the animated output
	 * @param string $engineVersion Override engine version to use during rendering
	 */
	public function startsImageOutputTask(
		string $environment,
		?string $templateId,
		?string $projectId,
		?string $outputType,
		?string $layoutToExport,
		float|int|null $pixelRatio,
		?string $engineVersion,
	): Response
	{
		return $this->connector->send(new StartsImageOutputTask($environment, $templateId, $projectId, $outputType, $layoutToExport, $pixelRatio, $engineVersion));
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function startsJpgOutputTask(string $environment): Response
	{
		return $this->connector->send(new StartsJpgOutputTask($environment));
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function startsPngOutputTask(string $environment): Response
	{
		return $this->connector->send(new StartsPngOutputTask($environment));
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function startsMp4outputTask(string $environment): Response
	{
		return $this->connector->send(new StartsMp4OutputTask($environment));
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function startsGifOutputTask(string $environment): Response
	{
		return $this->connector->send(new StartsGifOutputTask($environment));
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function startsPdfOutputTask(string $environment): Response
	{
		return $this->connector->send(new StartsPdfOutputTask($environment));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $taskId ID of the task
	 */
	public function returnsTaskStatus(string $environment, string $taskId): Response
	{
		return $this->connector->send(new ReturnsTaskStatus($environment, $taskId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $taskId ID of the task
	 */
	public function returnsTaskOutput(string $environment, string $taskId): Response
	{
		return $this->connector->send(new ReturnsTaskOutput($environment, $taskId));
	}
}
