<?php

namespace Ptb\Grafx\Resource;

use Ptb\Grafx\Requests\MyProjects\CreateProject;
use Ptb\Grafx\Requests\MyProjects\DeleteProject;
use Ptb\Grafx\Requests\MyProjects\RenameProject;
use Ptb\Grafx\Requests\MyProjects\GetProjects;
use Ptb\Grafx\Requests\MyProjects\GetProjectPreview;
use Ptb\Grafx\Requests\MyProjects\GetProject;
use Ptb\Grafx\Requests\MyProjects\GetProjectDocument;
use Ptb\Grafx\Requests\MyProjects\ReturnsPreviewGenerationTaskStatus;
use Ptb\Grafx\Requests\MyProjects\UpdateProjectDocument;
use Ptb\Grafx\Resource;
use Saloon\Http\Response;

class MyProjects extends Resource
{
	/**
	 * @param string $environment Name of the environment
	 * @param string $nextPageToken Next page token
	 * @param int $limit Amount of resources per response
	 */
	public function getProjects(
		string $environment,
		?string $nextPageToken = null,
		?int $limit = null,
	): Response
	{
		return $this->connector->send(new GetProjects($environment, $nextPageToken, $limit));
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function createProject(string $environment, string $name, string $templateId): Response
	{
		return $this->connector->send(new CreateProject($environment, $name, $templateId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $projectId My Project ID
	 */
	public function getProject(string $environment, string $projectId): Response
	{
		return $this->connector->send(new GetProject($environment, $projectId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $projectId My Project ID
	 */
	public function deleteProject(string $environment, string $projectId): Response
	{
		return $this->connector->send(new DeleteProject($environment, $projectId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $projectId My Project ID
	 */
	public function renameProject(string $environment, string $projectId): Response
	{
		return $this->connector->send(new RenameProject($environment, $projectId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $projectId My Project ID
	 */
	public function getProjectDocument(string $environment, string $projectId): Response
	{
		return $this->connector->send(new GetProjectDocument($environment, $projectId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $projectId My Project ID
	 */
	public function updateProjectDocument(string $environment, string $projectId): Response
	{
		return $this->connector->send(new UpdateProjectDocument($environment, $projectId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $projectId ID of the My Project
	 * @param string $previewType Type of preview
	 */
	public function getProjectPReview(
		string $environment,
		string $projectId,
		?string $previewType,
	): Response
	{
		return $this->connector->send(new GetProjectPreview($environment, $projectId, $previewType));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $taskId ID of the task
	 */
	public function returnsPreviewGenerationTaskStatus(string $environment, string $taskId): Response
	{
		return $this->connector->send(new ReturnsPreviewGenerationTaskStatus($environment, $taskId));
	}

}
