<?php

namespace Ptb\Grafx\Resource;

use Ptb\Grafx\Requests\Fonts\DeletesFontFamiliesByIdsInTheEnvironment;
use Ptb\Grafx\Requests\Fonts\DeletesFontStylesByIdsInTheEnvironment;
use Ptb\Grafx\Requests\Fonts\DeletesPreloadedFontStylesFromTheBatchByIdsInTheEnvironment;
use Ptb\Grafx\Requests\Fonts\RenamesFontFamilyByIdInTheEnvironment;
use Ptb\Grafx\Requests\Fonts\RenamesFontStyleByIdInTheEnvironment;
use Ptb\Grafx\Requests\Fonts\ReturnsAllAvailableFontStyleNames;
use Ptb\Grafx\Requests\Fonts\ReturnsAllFontFamiliesInTheEnvironment;
use Ptb\Grafx\Requests\Fonts\ReturnsAllFontStylesInTheFamily;
use Ptb\Grafx\Requests\Fonts\ReturnsFontStyleByIdInTheEnvironment;
use Ptb\Grafx\Requests\Fonts\ReturnsFontStyleFile;
use Ptb\Grafx\Requests\Fonts\ReturnsImagePreviewOfTheFontFamilyByIdInTheEnvironment;
use Ptb\Grafx\Requests\Fonts\ReturnsImagePreviewOfTheFontStyleByIdInTheEnvironment;
use Ptb\Grafx\Requests\Fonts\ReturnsImagePreviewOfThePreloadedFontStyleByIdInTheEnvironment;
use Ptb\Grafx\Requests\Fonts\StoresFontStylesToPersistentStorageByBatchId;
use Ptb\Grafx\Requests\Fonts\StoresFontStylesToTemporaryStorage;
use Ptb\Grafx\Requests\Fonts\StoresFontStylesToTemporaryStorageInTheProvidedBatch;
use Ptb\Grafx\Requests\Fonts\UpdatesFontStylesInTheBatch;
use Ptb\Grafx\Resource;
use Saloon\Http\Response;

class Fonts extends Resource
{
	/**
	 * @param string $environment Name of the environment
	 * @param string $nextPageToken Next page token
	 * @param mixed $sortBy Name of the field by which the sorting is performed
	 * @param mixed $sortOrder Order of resources, ascending or descending
	 * @param string $search Search by name
	 * @param int $limit Amount of resources per response
	 */
	public function returnsAllFontFamiliesInTheEnvironment(
		string $environment,
		?string $nextPageToken,
		mixed $sortBy,
		mixed $sortOrder,
		?string $search,
		?int $limit,
	): Response
	{
		return $this->connector->send(new ReturnsAllFontFamiliesInTheEnvironment($environment, $nextPageToken, $sortBy, $sortOrder, $search, $limit));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $ids Comma-separated ids of font families
	 */
	public function deletesFontFamiliesByIdsInTheEnvironment(string $environment, string $ids): Response
	{
		return $this->connector->send(new DeletesFontFamiliesByIdsInTheEnvironment($environment, $ids));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $fontFamilyId ID of the font family
	 */
	public function returnsImagePreviewOfTheFontFamilyByIdInTheEnvironment(
		string $environment,
		string $fontFamilyId,
	): Response
	{
		return $this->connector->send(new ReturnsImagePreviewOfTheFontFamilyByIdInTheEnvironment($environment, $fontFamilyId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $fontFamilyId Id of the font family
	 */
	public function returnsAllFontStylesInTheFamily(string $environment, string $fontFamilyId): Response
	{
		return $this->connector->send(new ReturnsAllFontStylesInTheFamily($environment, $fontFamilyId));
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function returnsAllAvailableFontStyleNames(string $environment): Response
	{
		return $this->connector->send(new ReturnsAllAvailableFontStyleNames($environment));
	}


	/**
	 * @param string $environment Environment name
	 * @param string $fontStyleId ID of the font style
	 */
	public function returnsFontStyleByIdInTheEnvironment(string $environment, string $fontStyleId): Response
	{
		return $this->connector->send(new ReturnsFontStyleByIdInTheEnvironment($environment, $fontStyleId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $fontStyleId ID of the font style
	 */
	public function renamesFontStyleByIdInTheEnvironment(string $environment, string $fontStyleId): Response
	{
		return $this->connector->send(new RenamesFontStyleByIdInTheEnvironment($environment, $fontStyleId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $fontFamilyId ID of the font family
	 */
	public function renamesFontFamilyByIdInTheEnvironment(string $environment, string $fontFamilyId): Response
	{
		return $this->connector->send(new RenamesFontFamilyByIdInTheEnvironment($environment, $fontFamilyId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $fontStyleId ID of the font style
	 */
	public function returnsImagePreviewOfTheFontStyleByIdInTheEnvironment(
		string $environment,
		string $fontStyleId,
	): Response
	{
		return $this->connector->send(new ReturnsImagePreviewOfTheFontStyleByIdInTheEnvironment($environment, $fontStyleId));
	}


	/**
	 * @param string $environment Environment name
	 * @param string $fontStyleId ID of the font style
	 */
	public function returnsFontStyleFile(string $environment, string $fontStyleId): Response
	{
		return $this->connector->send(new ReturnsFontStyleFile($environment, $fontStyleId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $ids Comma-separated ids of font styles
	 */
	public function deletesFontStylesByIdsInTheEnvironment(string $environment, string $ids): Response
	{
		return $this->connector->send(new DeletesFontStylesByIdsInTheEnvironment($environment, $ids));
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function storesFontStylesToTemporaryStorage(string $environment): Response
	{
		return $this->connector->send(new StoresFontStylesToTemporaryStorage($environment));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $batchId ID of the batch
	 */
	public function storesFontStylesToTemporaryStorageInTheProvidedBatch(string $environment, string $batchId): Response
	{
		return $this->connector->send(new StoresFontStylesToTemporaryStorageInTheProvidedBatch($environment, $batchId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $batchId ID of the batch
	 * @param string $ids Comma-separated ids of preloaded font styles
	 */
	public function deletesPreloadedFontStylesFromTheBatchByIdsInTheEnvironment(
		string $environment,
		string $batchId,
		string $ids,
	): Response
	{
		return $this->connector->send(new DeletesPreloadedFontStylesFromTheBatchByIdsInTheEnvironment($environment, $batchId, $ids));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $batchId ID of the batch
	 */
	public function updatesFontStylesInTheBatch(string $environment, string $batchId): Response
	{
		return $this->connector->send(new UpdatesFontStylesInTheBatch($environment, $batchId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $batchId ID of the batch
	 */
	public function storesFontStylesToPersistentStorageByBatchId(string $environment, string $batchId): Response
	{
		return $this->connector->send(new StoresFontStylesToPersistentStorageByBatchId($environment, $batchId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $batchId ID of the batch
	 * @param string $fontStyleId ID of the font style
	 * @param string $previewFormat Format of preview
	 */
	public function returnsImagePreviewOfThePreloadedFontStyleByIdInTheEnvironment(
		string $environment,
		string $batchId,
		string $fontStyleId,
		?string $previewFormat,
	): Response
	{
		return $this->connector->send(new ReturnsImagePreviewOfThePreloadedFontStyleByIdInTheEnvironment($environment, $batchId, $fontStyleId, $previewFormat));
	}
}
