<?php

namespace Ptb\Grafx\Requests\Templates;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Updates template by ID in the environment
 *
 * Updates template metadata (name and/or relative path) or body in the environment.<br />
 * Providing
 * the request body (JSON) and URL arguments (Template Name and/or Relative Path) simultaneously is not
 * allowed.<br />
 * IMPORTANT: When using Swagger to execute request for updating Template Name and/or
 * Relative Path please remove default request body
 */
class UpdateTemplate extends Request
{
	protected Method $method = Method::PUT;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/templates/{$this->templateId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateId ID of the template
	 * @param null|string $name Name of the template
	 * @param null|string $folderPath Folder to move updated template (NOTE: forward slashes only, should start with a slash)
	 */
	public function __construct(
		protected string $environment,
		protected string $templateId,
		protected ?string $name = null,
		protected ?string $folderPath = null,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter(['name' => $this->name, 'folderPath' => $this->folderPath]);
	}
}
