<?php

namespace Ptb\Grafx\Requests\Templates;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns the template collections that contain the template
 *
 * Returns the template collections that contain the template
 */
class ReturnsTheTemplateCollectionsThatContainTheTemplate extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/templates/{$this->templateId}/template-collections";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateId ID of the template
	 */
	public function __construct(
		protected string $environment,
		protected string $templateId,
	) {
	}
}
