<?php

namespace Ptb\Grafx\Requests\Templates;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Deletes template by ID in the environment
 *
 * Deletes template by ID in the environment
 */
class DeleteTemplate extends Request
{
	protected Method $method = Method::DELETE;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/templates/{$this->templateId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateId ID of the template
	 * @param null|bool $force When set to 'true' template is removed from all collections
	 */
	public function __construct(
		protected string $environment,
		protected string $templateId,
		protected ?bool $force = null,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter(['force' => $this->force]);
	}
}
