<?php

namespace Ptb\Grafx\Requests\TemplateCollections;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Updates template collection by ID in the environment
 *
 * Performs partial update of template collection, takes template collection JSON from the request
 * body. Can be used to update 'name' property
 */
class UpdatesTemplateCollectionByIdInTheEnvironment extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::PATCH;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/template-collections/{$this->templateCollectionId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateCollectionId ID of the template collection
	 */
	public function __construct(
		protected string $environment,
		protected string $templateCollectionId,
	) {
	}
}
