<?php

namespace Ptb\Grafx\Requests\TemplateCollections;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns all template collections in the environment
 *
 * Returns all template collections in the environment
 */
class ReturnsAllTemplateCollectionsInTheEnvironment extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/template-collections";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param null|string $nextPageToken Next page token
	 * @param null|int $limit Amount of resources per response
	 */
	public function __construct(
		protected string $environment,
		protected ?string $nextPageToken = null,
		protected ?int $limit = null,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter(['nextPageToken' => $this->nextPageToken, 'limit' => $this->limit]);
	}
}
