<?php

namespace Ptb\Grafx\Requests\Output;

use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Updates Output Settings
 *
 * To check structure and rules for different output settings, please see:<br /><br />
 * **JPG**
 * [/api/v1/environment/{environment}/output/settings/jpg](#/Output/post_api_v1_environment__environment__output_settings_jpg)<br
 * />
 * **PNG**
 * [/api/v1/environment/{environment}/output/settings/png](#/Output/post_api_v1_environment__environment__output_settings_png)<br
 * />
 * **PDF**
 * [/api/v1/environment/{environment}/output/settings/pdf](#/Output/post_api_v1_environment__environment__output_settings_pdf)<br
 * />
 * **GIF**
 * [/api/v1/environment/{environment}/output/settings/gif](#/Output/post_api_v1_environment__environment__output_settings_gif)<br
 * />
 * **MP4**
 * [/api/v1/environment/{environment}/output/settings/mp4](#/Output/post_api_v1_environment__environment__output_settings_mp4)<br
 * />
 */
class UpdatesOutputSettings extends Request
{
	protected Method $method = Method::PUT;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/output/settings/{$this->outputSettingsId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $outputSettingsId Output Settings ID
	 */
	public function __construct(
		protected string $environment,
		protected string $outputSettingsId,
	) {
	}
}
