<?php

namespace Ptb\Grafx\Requests\Output;

use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Deletes Output Settings by IDs in the environment
 *
 * Deletes Output Settings by IDs in the environment
 */
class DeletesOutputSettingsByIdsInTheEnvironment extends Request
{
	protected Method $method = Method::DELETE;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/output/settings";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $ids Comma-separated ids of Output Settings
	 */
	public function __construct(
		protected string $environment,
		protected string $ids,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter(['ids' => $this->ids]);
	}
}
