<?php

namespace Ptb\Grafx\Requests\Output;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Creates MP4 Output Settings
 *
 * **Name** is required and should be unique<br />
 * **Fps** is required and should be between 24 and
 * 60<br />
 * **Scaling** should be between 0.5 and 4<br />
 */
class CreatesMp4OutputSettings extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::POST;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/output/settings/mp4";
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function __construct(
		protected string $environment,
	) {
	}
}
