<?php

namespace Ptb\Grafx\Requests\MyProjects;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns image preview of the My Project by ID in the environment
 *
 * Returns image preview of the My Project by ID in the environment, or starts new preview generation
 * task and returns it's ID
 */
class GetProjectPreview extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/projects/{$this->projectId}/preview";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $projectId ID of the My Project
	 * @param null|string $previewType Type of preview
	 */
	public function __construct(
		protected string $environment,
		protected string $projectId,
		protected ?string $previewType = null,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter(['previewType' => $this->previewType]);
	}
}
