<?php

namespace Ptb\Grafx\Requests\MyProjects;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns My Project document
 *
 * Returns My Project document
 */
class GetProjectDocument extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/projects/{$this->projectId}/document";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $projectId My Project ID
	 */
	public function __construct(
		protected string $environment,
		protected string $projectId,
	) {
	}
}
