<?php

namespace Ptb\Grafx\Requests\MyProjects;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Deletes My Project
 *
 * Deletes My Project by ID
 */
class DeleteProject extends Request
{
	protected Method $method = Method::DELETE;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/projects/{$this->projectId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $projectId My Project ID
	 */
	public function __construct(
		protected string $environment,
		protected string $projectId,
	) {
	}
}
