<?php

namespace Ptb\Grafx\Requests\MyProjects;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Creates My Project
 *
 * Creates My Project. Name is optional; when not set, the Template name is used
 */
class CreateProject extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::POST;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/projects";
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function __construct(
		protected string $environment,
        public string $name,
        public string $templateId,
	) {

        $this->body()->add('name', $this->name);
        $this->body()->add('userInterfaceId', config('services.grafx.userInterfaceId'));
        $this->body()->add('template', [
            'id' => $this->templateId
        ]);
	}
}
