<?php

namespace Ptb\Grafx\Requests\Media;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Updates media by ID in the environment
 *
 * Returns updated media by ID in the environment
 */
class UpdatesMediaByIdInTheEnvironment extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::PATCH;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/media/{$this->mediaId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $mediaId ID of the media
	 * @param null|string $name The new name for the media (if any)
	 * @param null|string $folderPath The new location for the media (if any)
	 */
	public function __construct(
		protected string $environment,
		protected string $mediaId,
		protected ?string $name = null,
		protected ?string $folderPath = null,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter(['name' => $this->name, 'folderPath' => $this->folderPath]);
	}
}
