<?php

namespace Ptb\Grafx\Requests\Media;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Downloads media by ID in the environment
 *
 * Downloads media by ID in the environment
 */
class DownloadsMediaByIdInTheEnvironment extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/media/{$this->mediaId}/download";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $mediaId ID of the media
	 */
	public function __construct(
		protected string $environment,
		protected string $mediaId,
	) {
	}
}
