<?php

namespace Ptb\Grafx\Requests\Fonts;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Updates font styles in the batch
 *
 * Updates font styles in the batch. Update of style name and family name is supported
 */
class UpdatesFontStylesInTheBatch extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::PATCH;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/font-styles/temp/{$this->batchId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $batchId ID of the batch
	 */
	public function __construct(
		protected string $environment,
		protected string $batchId,
	) {
	}
}
