<?php

namespace Ptb\Grafx\Requests\Fonts;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Stores font styles to a temporary storage in the provided batch
 *
 * Stores font styles to a temporary storage adding them to the provided batch, returns decoded
 * metadata. Supported formats: .ttf, .otf, .zip
 */
class StoresFontStylesToTemporaryStorageInTheProvidedBatch extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::POST;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/font-styles/temp/{$this->batchId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $batchId ID of the batch
	 */
	public function __construct(
		protected string $environment,
		protected string $batchId,
	) {
	}
}
