<?php

namespace Ptb\Grafx\Requests\Fonts;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Stores font styles to a temporary storage
 *
 * Stores font styles to a temporary storage and returns decoded metadata. Supported formats: .ttf,
 * .otf, .zip
 */
class StoresFontStylesToTemporaryStorage extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::POST;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/font-styles/temp";
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function __construct(
		protected string $environment,
	) {
	}
}
