<?php

namespace Ptb\Grafx\Requests\Fonts;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns image preview of the font style by ID in the environment
 *
 * Returns image preview of the font style by ID in the environment
 */
class ReturnsImagePreviewOfTheFontStyleByIdInTheEnvironment extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/font-styles/{$this->fontStyleId}/preview";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $fontStyleId ID of the font style
	 */
	public function __construct(
		protected string $environment,
		protected string $fontStyleId,
	) {
	}
}
