<?php

namespace Ptb\Grafx\Requests\Fonts;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns image preview of the font family by ID in the environment
 *
 * Returns image preview of the font family by ID in the environment
 */
class ReturnsImagePreviewOfTheFontFamilyByIdInTheEnvironment extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/font-families/{$this->fontFamilyId}/preview";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $fontFamilyId ID of the font family
	 */
	public function __construct(
		protected string $environment,
		protected string $fontFamilyId,
	) {
	}
}
