<?php

namespace Ptb\Grafx\Requests\Fonts;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns font style by ID in the environment
 *
 * Returns font style by ID in the environment
 */
class ReturnsFontStyleByIdInTheEnvironment extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/font-styles/{$this->fontStyleId}";
	}


	/**
	 * @param string $environment Environment name
	 * @param string $fontStyleId ID of the font style
	 */
	public function __construct(
		protected string $environment,
		protected string $fontStyleId,
	) {
	}
}
