<?php

namespace Ptb\Grafx\Requests\Fonts;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns all font families in the environment
 *
 * Returns all font families in the environment
 */
class ReturnsAllFontFamiliesInTheEnvironment extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/font-families";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param null|string $nextPageToken Next page token
	 * @param null|mixed $sortBy Name of the field by which the sorting is performed
	 * @param null|mixed $sortOrder Order of resources, ascending or descending
	 * @param null|string $search Search by name
	 * @param null|int $limit Amount of resources per response
	 */
	public function __construct(
		protected string $environment,
		protected ?string $nextPageToken = null,
		protected mixed $sortBy = null,
		protected mixed $sortOrder = null,
		protected ?string $search = null,
		protected ?int $limit = null,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter([
			'nextPageToken' => $this->nextPageToken,
			'sortBy' => $this->sortBy,
			'sortOrder' => $this->sortOrder,
			'search' => $this->search,
			'limit' => $this->limit,
		]);
	}
}
