<?php

namespace Ptb\Grafx\Requests\Fonts;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Deletes font styles by IDs in the environment
 *
 * Deletes font styles by IDs in the environment
 */
class DeletesFontStylesByIdsInTheEnvironment extends Request
{
	protected Method $method = Method::DELETE;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/font-styles";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $ids Comma-separated ids of font styles
	 */
	public function __construct(
		protected string $environment,
		protected string $ids,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter(['ids' => $this->ids]);
	}
}
