<?php

namespace Ptb\Grafx;

use Illuminate\Support\ServiceProvider;


class GrafxServiceProvider extends ServiceProvider
{

    /**
     * Register any application services
     *
     * @return void
     */
    public function register(): void
    {

    }

    /**
     * Bootstrap any application services
     *
     * @return void
     */
    public function boot(): void
    {

        $this->mergeConfigFrom(
            path: __DIR__ . '/../config/services.php',
            key: 'services'
        );

        $this->commands([
            //
        ]);


        $this->app->singleton(Grafx::class, function ($app) {
            $connector = new Grafx(environment: config('services.grafx.environment'));
            $authenticator = $connector->getAccessToken();
            $connector->authenticate($authenticator);
            return $connector;
        });
    }

    /**
     * Get the services provided by the provider
     *
     * @return string[]
     */
    public function provides(): array
    {
        return [

        ];
    }
}
