<?php

namespace Ptb\Grafx;

use Ptb\Grafx\Resource\Fonts;
use Ptb\Grafx\Resource\FontsObsolete;
use Ptb\Grafx\Resource\Health;
use Ptb\Grafx\Resource\Info;
use Ptb\Grafx\Resource\Media;
use Ptb\Grafx\Resource\MyProjects;
use Ptb\Grafx\Resource\Output;
use Ptb\Grafx\Resource\TemplateCollections;
use Ptb\Grafx\Resource\Templates;
use Saloon\Helpers\OAuth2\OAuthConfig;
use Saloon\Http\Connector;
use Saloon\Http\OAuth2\GetClientCredentialsTokenRequest;
use Saloon\Traits\OAuth2\ClientCredentialsGrant;
use Saloon\Traits\Plugins\AcceptsJson;

/**
 * CHILI GraFx Environment
 *
 * API allowing integration with the CHILI GraFx Environment.
 */
class Grafx extends Connector
{
    use AcceptsJson, ClientCredentialsGrant;

	public function resolveBaseUrl(): string
	{
		return "https://{$this->environment}.chili-publish.online/grafx";
	}

    protected function defaultOauthConfig(): OAuthConfig
    {
        return OAuthConfig::make()
            ->setClientId('csTqbZVTl57axklJeLwUYFNkQl1Fcshk') // @todo: move to configuration
            ->setClientSecret('sALlh-c64XPpCh6Vi6EtVQozAoRkPsY7I4ucVpvtTc0DkyFH0Hwrqa4LhC25jj3j') // @todo: move to configuration
	        ->setDefaultScopes(['*'])
            ->setTokenEndpoint('https://integration-login.chiligrafx.com/oauth/token')
            ->setRequestModifier(function (GetClientCredentialsTokenRequest $request) {
                $request->body()->add('audience', 'https://chiligrafx.com');
            });
    }

    public function __construct(
        public string $environment
    )
    {}

	public function fonts(): Fonts
	{
		return new Fonts($this);
	}

	public function health(): Health
	{
		return new Health($this);
	}


	public function info(): Info
	{
		return new Info($this);
	}


	public function media(): Media
	{
		return new Media($this);
	}


	public function myProjects(): MyProjects
	{
		return new MyProjects($this);
	}


	public function output(): Output
	{
		return new Output($this);
	}


	public function templateCollections(): TemplateCollections
	{
		return new TemplateCollections($this);
	}


	public function templates(): Templates
	{
		return new Templates($this);
	}
}
