<?php

namespace Ptb\Grafx\Resource;

use Ptb\Grafx\Requests\MyProjects\CreatesMyProject;
use Ptb\Grafx\Requests\MyProjects\DeletesMyProject;
use Ptb\Grafx\Requests\MyProjects\RenamesMyProject;
use Ptb\Grafx\Requests\MyProjects\ReturnsAllMyProjectsOfTheCurrentUser;
use Ptb\Grafx\Requests\MyProjects\ReturnsImagePreviewOfTheMyProjectByIdInTheEnvironment;
use Ptb\Grafx\Requests\MyProjects\ReturnsMyProjectByIdInTheEnvironment;
use Ptb\Grafx\Requests\MyProjects\ReturnsMyProjectDocument;
use Ptb\Grafx\Requests\MyProjects\ReturnsPreviewGenerationTaskStatus;
use Ptb\Grafx\Requests\MyProjects\UpdatesMyProjectDocument;
use Ptb\Grafx\Resource;
use Saloon\Http\Response;

class MyProjects extends Resource
{
	/**
	 * @param string $environment Name of the environment
	 * @param string $nextPageToken Next page token
	 * @param int $limit Amount of resources per response
	 */
	public function returnsAllMyProjectsOfTheCurrentUser(
		string $environment,
		?string $nextPageToken,
		?int $limit,
	): Response
	{
		return $this->connector->send(new ReturnsAllMyProjectsOfTheCurrentUser($environment, $nextPageToken, $limit));
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function createsMyProject(string $environment): Response
	{
		return $this->connector->send(new CreatesMyProject($environment));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $projectId My Project ID
	 */
	public function returnsMyProjectByIdInTheEnvironment(string $environment, string $projectId): Response
	{
		return $this->connector->send(new ReturnsMyProjectByIdInTheEnvironment($environment, $projectId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $projectId My Project ID
	 */
	public function deletesMyProject(string $environment, string $projectId): Response
	{
		return $this->connector->send(new DeletesMyProject($environment, $projectId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $projectId My Project ID
	 */
	public function renamesMyProject(string $environment, string $projectId): Response
	{
		return $this->connector->send(new RenamesMyProject($environment, $projectId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $projectId My Project ID
	 */
	public function returnsMyProjectDocument(string $environment, string $projectId): Response
	{
		return $this->connector->send(new ReturnsMyProjectDocument($environment, $projectId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $projectId My Project ID
	 */
	public function updatesMyProjectDocument(string $environment, string $projectId): Response
	{
		return $this->connector->send(new UpdatesMyProjectDocument($environment, $projectId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $projectId ID of the My Project
	 * @param string $previewType Type of preview
	 */
	public function returnsImagePreviewOfTheMyProjectByIdInTheEnvironment(
		string $environment,
		string $projectId,
		?string $previewType,
	): Response
	{
		return $this->connector->send(new ReturnsImagePreviewOfTheMyProjectByIdInTheEnvironment($environment, $projectId, $previewType));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $taskId ID of the task
	 */
	public function returnsPreviewGenerationTaskStatus(string $environment, string $taskId): Response
	{
		return $this->connector->send(new ReturnsPreviewGenerationTaskStatus($environment, $taskId));
	}


	/**
	 * @todo Fix duplicated method name
	 * @param string $environment Name of the environment
	 * @param string $projectId ID of the My Project
	 * @param string $previewType Type of preview
	 */
	public function returnsImagePreviewOfTheMyProjectByIdInTheEnvironmentDuplicate1(
		string $environment,
		string $projectId,
		string $previewType,
	): Response
	{
		return $this->connector->send(new ReturnsImagePreviewOfTheMyProjectByIdInTheEnvironment($environment, $projectId, $previewType));
	}
}
