<?php

namespace Ptb\Grafx\Resource;

use Ptb\Grafx\Requests\Media\CreatesEmptyMediaDirectoryInTheEnvironment;
use Ptb\Grafx\Requests\Media\CreatesNewMediaInTheEnvironment;
use Ptb\Grafx\Requests\Media\DeletesMediaByIdInTheEnvironment;
use Ptb\Grafx\Requests\Media\DownloadsMediaByIdInTheEnvironment;
use Ptb\Grafx\Requests\Media\RemovesMediaDirectoryInTheEnvironmentWithAllAssetsAndSubfoldersInside;
use Ptb\Grafx\Requests\Media\ReturnsAllMediaAndDirectoriesInTheEnvironment;
use Ptb\Grafx\Requests\Media\ReturnsAllMediaInTheEnvironmentIncludingSubfolders;
use Ptb\Grafx\Requests\Media\ReturnsImagePreviewOfTheMediaByIdInTheEnvironment;
use Ptb\Grafx\Requests\Media\ReturnsMediaByIdInTheEnvironment;
use Ptb\Grafx\Requests\Media\UpdatesDirectoryInTheEnvironment;
use Ptb\Grafx\Requests\Media\UpdatesMediaByIdInTheEnvironment;
use Ptb\Grafx\Resource;
use Saloon\Http\Response;

class Media extends Resource
{
	/**
	 * @param string $environment Name of the environment
	 * @param string $nextPageToken Next page token
	 * @param int $limit Amount of resources per response
	 * @param string $sortBy Name of the field by which the sorting is performed
	 * @param mixed $sortOrder Order of resources, ascending or descending
	 * @param string $folder Folder in which search should be done (NOTE: forward slashes only, should start with a slash)
	 * @param string $search Search by name, relativePath or resource ID
	 * @param bool $includeItemsFromSubfolders When 'true', items from subfolders are included in response
	 * @param bool $includeFolders When 'true', directory items are included in response
	 */
	public function returnsAllMediaInTheEnvironmentIncludingSubfolders(
		string $environment,
		?string $nextPageToken,
		?int $limit,
		?string $sortBy,
		mixed $sortOrder,
		?string $folder,
		?string $search,
		?bool $includeItemsFromSubfolders,
		?bool $includeFolders,
	): Response
	{
		return $this->connector->send(new ReturnsAllMediaInTheEnvironmentIncludingSubfolders($environment, $nextPageToken, $limit, $sortBy, $sortOrder, $folder, $search, $includeItemsFromSubfolders, $includeFolders));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $name Name of media
	 * @param string $folderPath Folder to place created media (NOTE: forward slashes only, should start with a slash)
	 */
	public function createsNewMediaInTheEnvironment(string $environment, string $name, string $folderPath): Response
	{
		return $this->connector->send(new CreatesNewMediaInTheEnvironment($environment, $name, $folderPath));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $nextPageToken Next page token
	 * @param int $limit Amount of items (resources and folders) per response
	 * @param string $sortBy Name of the field by which the sorting is performed
	 * @param mixed $sortOrder Order of resources, ascending or descending
	 * @param string $folder Folder in which search should be done (NOTE: forward slashes only, should start with a slash)
	 * @param string $search Search by name, relativePath or resource ID
	 */
	public function returnsAllMediaAndDirectoriesInTheEnvironment(
		string $environment,
		?string $nextPageToken,
		?int $limit,
		?string $sortBy,
		mixed $sortOrder,
		?string $folder,
		?string $search,
	): Response
	{
		return $this->connector->send(new ReturnsAllMediaAndDirectoriesInTheEnvironment($environment, $nextPageToken, $limit, $sortBy, $sortOrder, $folder, $search));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $name Name of the folder to create
	 * @param string $folderPath Folder to place created media folder (NOTE: forward slashes only, should start with a slash)
	 */
	public function createsEmptyMediaDirectoryInTheEnvironment(
		string $environment,
		string $name,
		string $folderPath,
	): Response
	{
		return $this->connector->send(new CreatesEmptyMediaDirectoryInTheEnvironment($environment, $name, $folderPath));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $mediaId ID of the media
	 */
	public function returnsMediaByIdInTheEnvironment(string $environment, string $mediaId): Response
	{
		return $this->connector->send(new ReturnsMediaByIdInTheEnvironment($environment, $mediaId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $mediaId ID of the media
	 */
	public function deletesMediaByIdInTheEnvironment(string $environment, string $mediaId): Response
	{
		return $this->connector->send(new DeletesMediaByIdInTheEnvironment($environment, $mediaId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $mediaId ID of the media
	 * @param string $name The new name for the media (if any)
	 * @param string $folderPath The new location for the media (if any)
	 */
	public function updatesMediaByIdInTheEnvironment(
		string $environment,
		string $mediaId,
		?string $name,
		?string $folderPath,
	): Response
	{
		return $this->connector->send(new UpdatesMediaByIdInTheEnvironment($environment, $mediaId, $name, $folderPath));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $mediaId ID of the media
	 */
	public function downloadsMediaByIdInTheEnvironment(string $environment, string $mediaId): Response
	{
		return $this->connector->send(new DownloadsMediaByIdInTheEnvironment($environment, $mediaId));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $mediaId ID of the media
	 * @param string $previewType Type of preview
	 */
	public function returnsImagePreviewOfTheMediaByIdInTheEnvironment(
		string $environment,
		string $mediaId,
		?string $previewType,
	): Response
	{
		return $this->connector->send(new ReturnsImagePreviewOfTheMediaByIdInTheEnvironment($environment, $mediaId, $previewType));
	}


	/**
	 * @todo Fix duplicated method name
	 * @param string $environment Name of the environment
	 * @param string $mediaId ID of the media
	 * @param string $previewType Type of preview
	 */
	public function returnsImagePreviewOfTheMediaByIdInTheEnvironmentDuplicate1(
		string $environment,
		string $mediaId,
		string $previewType,
	): Response
	{
		return $this->connector->send(new ReturnsImagePreviewOfTheMediaByIdInTheEnvironment($environment, $mediaId, $previewType));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $directoryId ID of the directory
	 * @param string $name The new name for the media directory
	 * @param string $folderPath Folder to move media directory (NOTE: forward slashes only, should start with a slash)
	 */
	public function updatesDirectoryInTheEnvironment(
		string $environment,
		string $directoryId,
		string $name,
		string $folderPath,
	): Response
	{
		return $this->connector->send(new UpdatesDirectoryInTheEnvironment($environment, $directoryId, $name, $folderPath));
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $directoryId Directory resource ID
	 */
	public function removesMediaDirectoryInTheEnvironmentWithAllAssetsAndSubfoldersInside(
		string $environment,
		string $directoryId,
	): Response
	{
		return $this->connector->send(new RemovesMediaDirectoryInTheEnvironmentWithAllAssetsAndSubfoldersInside($environment, $directoryId));
	}
}
