<?php

namespace Ptb\Grafx\Requests\Templates;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns all templates in the environment including subfolders
 *
 * Returns all templates in the environment including subfolders
 */
class ReturnsAllTemplatesInTheEnvironmentIncludingSubfolders extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/templates";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param null|string $nextPageToken Next page token
	 * @param null|int $limit Amount of resources per response
	 * @param null|string $sortBy Name of the field by which the sorting is performed
	 * @param null|mixed $sortOrder Order of resources, ascending or descending
	 * @param null|string $folder Folder in which search should be done (NOTE: forward slashes only, should start with a slash)
	 * @param null|string $search Search by name, relativePath or resource ID
	 * @param null|bool $includeItemsFromSubfolders When 'true', items from subfolders are included in response
	 * @param null|bool $includeFolders When 'true', directory items are included in response
	 */
	public function __construct(
		protected string $environment,
		protected ?string $nextPageToken = null,
		protected ?int $limit = null,
		protected ?string $sortBy = null,
		protected mixed $sortOrder = null,
		protected ?string $folder = null,
		protected ?string $search = null,
		protected ?bool $includeItemsFromSubfolders = null,
		protected ?bool $includeFolders = null,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter([
			'nextPageToken' => $this->nextPageToken,
			'limit' => $this->limit,
			'sortBy' => $this->sortBy,
			'sortOrder' => $this->sortOrder,
			'folder' => $this->folder,
			'search' => $this->search,
			'includeItemsFromSubfolders' => $this->includeItemsFromSubfolders,
			'includeFolders' => $this->includeFolders,
		]);
	}
}
