<?php

namespace Ptb\Grafx\Requests\Templates;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns image preview of the template by ID in the environment
 *
 * Returns image preview of the template by ID in the environment, or starts new preview generation
 * task and returns it's ID
 */
class GetTemplatePreview extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/templates/{$this->templateId}/preview";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateId ID of the template
	 * @param null|string $previewType Type of preview
	 */
	public function __construct(
		protected string $environment,
		protected string $templateId,
		protected ?string $previewType = null,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter(['previewType' => $this->previewType]);
	}
}
