<?php

namespace Ptb\Grafx\Requests\Templates;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Downloads template by ID in the environment
 *
 * Downloads template by ID in the environment
 */
class DownloadTemplate extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/templates/{$this->templateId}/download";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateId ID of the template
	 */
	public function __construct(
		protected string $environment,
		protected string $templateId,
	) {
	}
}
