<?php

namespace Ptb\Grafx\Requests\TemplateCollections;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns template collection by ID in the environment
 *
 * Returns template collection by ID in the environment
 */
class ReturnsTemplateCollectionByIdInTheEnvironment extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/template-collections/{$this->templateCollectionId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateCollectionId ID of the template collection
	 */
	public function __construct(
		protected string $environment,
		protected string $templateCollectionId,
	) {
	}
}
