<?php

namespace Ptb\Grafx\Requests\TemplateCollections;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Renames template in template collection
 *
 * Renames template in template collection. Original template name is not changed
 */
class RenamesTemplateInTemplateCollection extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::PATCH;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/template-collections/{$this->templateCollectionId}/templates/{$this->templateId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateCollectionId ID of the template collection
	 * @param string $templateId ID of the template
	 */
	public function __construct(
		protected string $environment,
		protected string $templateCollectionId,
		protected string $templateId,
	) {
	}
}
