<?php

namespace Ptb\Grafx\Requests\TemplateCollections;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Deletes template from template collection
 *
 * Deletes template from template collection
 */
class DeletesTemplateFromTemplateCollection extends Request
{
	protected Method $method = Method::DELETE;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/template-collections/{$this->templateCollectionId}/templates/{$this->templateId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $templateCollectionId ID of the template collection
	 * @param string $templateId ID of the template
	 */
	public function __construct(
		protected string $environment,
		protected string $templateCollectionId,
		protected string $templateId,
	) {
	}
}
