<?php

namespace Ptb\Grafx\Requests\Output;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns task status
 *
 * Returns task status
 */
class ReturnsTaskStatus extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/output/tasks/{$this->taskId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $taskId ID of the task
	 */
	public function __construct(
		protected string $environment,
		protected string $taskId,
	) {
	}
}
