<?php

namespace Ptb\Grafx\Requests\Output;

use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns all Output Settings in the environment
 *
 * Returns all Output Settings in the environment. Only base information is included
 */
class ReturnsAllOutputSettingsInTheEnvironment extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/output/settings";
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function __construct(
		protected string $environment,
	) {
	}
}
