<?php

namespace Ptb\Grafx\Requests\Output;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Creates JPG Output Settings
 *
 * **Name** is required and should be unique<br />
 * **Quality** or **MaxFileSizeInKiloBytes** should be
 * provided. Providing both values simultaneously is not allowed<br />
 * **Quality** should be between 1
 * and 100<br />
 * **MaxFileSizeInKiloBytes** should be positive (if provided)<br />
 * **Scaling** should
 * be between 0.5 and 4<br />
 */
class CreatesJpgOutputSettings extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::POST;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/output/settings/jpg";
	}


	/**
	 * @param string $environment Name of the environment
	 */
	public function __construct(
		protected string $environment,
	) {
	}
}
