<?php

namespace Ptb\Grafx\Requests\MyProjects;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Renames My Project
 *
 * Renames My Project. Other updated properties are ignored
 */
class RenamesMyProject extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::PATCH;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/projects/{$this->projectId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $projectId My Project ID
	 */
	public function __construct(
		protected string $environment,
		protected string $projectId,
	) {
	}
}
