<?php

namespace Ptb\Grafx\Requests\Media;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Returns all media and directories in the environment
 *
 * Returns all media and directories located directly in requested folder (in root when no folder is
 * provided) in the environment, excluding subfolders
 */
class ReturnsAllMediaAndDirectoriesInTheEnvironment extends Request
{
	protected Method $method = Method::GET;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/media/directory";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param null|string $nextPageToken Next page token
	 * @param null|int $limit Amount of items (resources and folders) per response
	 * @param null|string $sortBy Name of the field by which the sorting is performed
	 * @param null|mixed $sortOrder Order of resources, ascending or descending
	 * @param null|string $folder Folder in which search should be done (NOTE: forward slashes only, should start with a slash)
	 * @param null|string $search Search by name, relativePath or resource ID
	 */
	public function __construct(
		protected string $environment,
		protected ?string $nextPageToken = null,
		protected ?int $limit = null,
		protected ?string $sortBy = null,
		protected mixed $sortOrder = null,
		protected ?string $folder = null,
		protected ?string $search = null,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter([
			'nextPageToken' => $this->nextPageToken,
			'limit' => $this->limit,
			'sortBy' => $this->sortBy,
			'sortOrder' => $this->sortOrder,
			'folder' => $this->folder,
			'search' => $this->search,
		]);
	}
}
