<?php

namespace Ptb\Grafx\Requests\Media;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Removes media directory in the environment with all assets and subfolders inside
 *
 * Removes media directory in the environment with all assets and subfolders inside
 */
class RemovesMediaDirectoryInTheEnvironmentWithAllAssetsAndSubfoldersInside extends Request
{
	protected Method $method = Method::DELETE;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/media/directory/{$this->directoryId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $directoryId Directory resource ID
	 */
	public function __construct(
		protected string $environment,
		protected string $directoryId,
	) {
	}
}
