<?php

namespace Ptb\Grafx\Requests\Media;

use DateTime;
use Saloon\Enums\Method;
use Saloon\Http\Request;

/**
 * Deletes media by ID in the environment
 *
 * Deletes media by ID in the environment
 */
class DeletesMediaByIdInTheEnvironment extends Request
{
	protected Method $method = Method::DELETE;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/media/{$this->mediaId}";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $mediaId ID of the media
	 */
	public function __construct(
		protected string $environment,
		protected string $mediaId,
	) {
	}
}
