<?php

namespace Ptb\Grafx\Requests\Media;

use DateTime;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

/**
 * Creates a new media in the environment
 *
 * Creates a new media in the environment, takes media file from the request body
 */
class CreatesNewMediaInTheEnvironment extends Request implements HasBody
{
	use HasJsonBody;

	protected Method $method = Method::POST;


	public function resolveEndpoint(): string
	{
		return "/api/v1/environment/{$this->environment}/media";
	}


	/**
	 * @param string $environment Name of the environment
	 * @param string $name Name of media
	 * @param string $folderPath Folder to place created media (NOTE: forward slashes only, should start with a slash)
	 */
	public function __construct(
		protected string $environment,
		protected string $name,
		protected string $folderPath,
	) {
	}


	public function defaultQuery(): array
	{
		return array_filter(['name' => $this->name, 'folderPath' => $this->folderPath]);
	}
}
